% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportHTML.R
\name{can.interact}
\alias{can.interact}
\alias{can.interact.default}
\alias{can.interact.inzplotoutput}
\alias{can.interact.ggplot}
\title{Identify if a plot can be interactive}
\usage{
can.interact(x)

\method{can.interact}{default}(x)

\method{can.interact}{inzplotoutput}(x)

\method{can.interact}{ggplot}(x)
}
\arguments{
\item{x}{a plot object returned from a plotting function}
}
\value{
Logical to identify if there is an interactive version
}
\description{
Several iNZightPlots graphs have been enabled with custom interaction,
while others make use of the automatic output of `plotly`.
This function returns `TRUE` if the provided plot has interaction
(as determined by iNZight), and `FALSE` otherwise.
}
\details{
Not that, while most `ggplot2` graphs can be passed to `plotly`,
and even though we are using plot.ly directly for some of our ggplot2
graphs, we still only return `TRUE` if the graph was created
by one of the packages in the iNZight collection.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default interaction helper (always returns `FALSE`)

\item \code{inzplotoutput}: Graphs from `iNZightPlot()`, many of which
have interaction enabled, but some do not (for example, hex plots)

\item \code{ggplot}: Those `iNZight*` plotting functions which return
a `ggplot2` object and have been tested to work with plotly
will be tagged as such; this is just a helper to check for
the necessary attribute.
}}

\examples{
can.interact(iNZightPlot(Sepal.Length, data = iris))
}
\author{
Tom Elliott, Yu Han Soh
}
