% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_var.R
\name{rankVars}
\alias{rankVars}
\title{Rank the data of a numeric variables}
\usage{
rankVars(.data, vars)
}
\arguments{
\item{.data}{a dataframe with the variables to rank}

\item{vars}{a character vector of numeric variables in \code{.data}
to rank}
}
\value{
the original dataframe containing new columns with the ranks of the
        variables in \code{var} with tidyverse code attached
}
\description{
Rank the values of a numeric variable in descending order,
and returns the result along with tidyverse code used to generate it.
Ties are broken as such: eg. values = 5, 6, 6, 7 ; rank = 1, 2, 2, 3
}
\examples{
ranked <- rankVars(iris, vars = c("Sepal.Length", "Petal.Length"))
cat(code(ranked))
head(ranked)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
