% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{SPBoot}
\alias{SPBoot}
\title{Estimation of species relative abundance or detection probability distribution}
\usage{
SPBoot(x, datatype = "abundance")
}
\arguments{
\item{x}{a vector/matrix/list of species abundances or a matrix of raw incidence table.\cr}

\item{datatype}{of input data: individual-based abundance data (datatype = "abundance"), sampling-unit-based incidence frequencies data (datatype = "incidence_freq") or species by sampling-units incidence matrix (datatype = "incidence_raw")..}
}
\value{
a list of vector with species relative abundance or detection probability distribution.
}
\description{
\code{SPBoot}: Expand bootstraping species relative abundance or detection probability
}
\examples{
data(bird)
bird.inc <- bird$inci
SPBoot(bird$abun, datatype="abundance")
SPBoot(bird$inci, datatype="incidence_raw")
}

