% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_prepare_whoi_plankton.R
\name{ifcb_prepare_whoi_plankton}
\alias{ifcb_prepare_whoi_plankton}
\title{Download and Prepare WHOI-Plankton Data}
\usage{
ifcb_prepare_whoi_plankton(
  years,
  png_folder,
  raw_folder,
  manual_folder,
  class2use_file,
  skip_classes = NULL,
  dashboard_url = "https://ifcb-data.whoi.edu/mvco/",
  extract_images = FALSE,
  download_blobs = FALSE,
  blobs_folder = NULL,
  download_features = FALSE,
  features_folder = NULL,
  parallel_downloads = 5,
  sleep_time = 2,
  multi_timeout = 120,
  convert_filenames = TRUE,
  convert_adc = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{years}{Character vector. Years to download and process. For available years, see \url{https://hdl.handle.net/1912/7341} or \code{\link{ifcb_download_whoi_plankton}}.}

\item{png_folder}{Character. Directory where \code{.png} images will be stored.}

\item{raw_folder}{Character. Directory where raw files (\code{.adc}, \code{.hdr}, \code{.roi}) will be stored.}

\item{manual_folder}{Character. Directory where manual classification files (\code{.mat}) will be stored.}

\item{class2use_file}{Character. File path to \code{.mat} file to store the list of available classes.}

\item{skip_classes}{Character vector. Classes to be excluded during processing. For example images, refer to \url{https://whoigit.github.io/whoi-plankton/}.}

\item{dashboard_url}{Character. URL for the IFCB dashboard data source (default: "https://ifcb-data.whoi.edu/mvco/").}

\item{extract_images}{Logical. If \code{TRUE}, extracts \code{.png} images from the downloaded archives and removes the \code{.zip} files.
If \code{FALSE}, only downloads the archives without extracting images. Default is \code{FALSE}.}

\item{download_blobs}{Logical. Whether to download blob files (default: FALSE).}

\item{blobs_folder}{Character. Directory where blob files will be stored (required if \code{download_blobs = TRUE}).}

\item{download_features}{Logical. Whether to download feature files (default: FALSE).}

\item{features_folder}{Character. Directory where feature files will be stored (required if \code{download_features = TRUE}).}

\item{parallel_downloads}{Integer. Number of parallel IFCB Dashboard downloads (default: 10).}

\item{sleep_time}{Numeric. Seconds to wait between download requests (default: 2).}

\item{multi_timeout}{Numeric. Timeout for multiple requests in seconds (default: 120).}

\item{convert_filenames}{Logical. If \code{TRUE} (default), converts filenames of the old format \code{"IFCBxxx_YYYY_DDD_HHMMSS"}
to the new format (\code{DYYYYMMDDTHHMMSS_IFCBXXX}).
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{convert_adc}{Logical. If \code{TRUE} (default), adjusts \code{.adc} files from older IFCB instruments
(IFCB1–6, with filenames in the format \code{"IFCBxxx_YYYY_DDD_HHMMSS"}) by inserting
four empty columns after column 7 to match the newer format.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{quiet}{Logical. Suppress messages if TRUE (default: FALSE).}
}
\value{
This function does not return a value but downloads, processes, and stores IFCB data.
}
\description{
This function downloads manually annotated images from the WHOI-Plankton dataset (Sosik et al. 2015) and generates manual
classification files in \code{.mat} format that can be used to train an image classifier using the \code{ifcb-analysis} MATLAB package (Sosik and Olson 2007).
}
\details{
This function requires a python interpreter to be installed. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

This is a wrapper function for the \code{\link{ifcb_download_whoi_plankton}}, \code{\link{ifcb_download_dashboard_data}} and \code{\link{ifcb_create_empty_manual_file}} functions and used for downloading, processing, and converting IFCB data.
Please note that this function downloads and extracts large amounts of data, which can take considerable time.

The training data prepared from this function can be merged with an existing training dataset using the \code{\link{ifcb_merge_manual}} function.

To exclude images from the training dataset, either exclude the class completely with the \code{skip_classes} argument,
or set \code{extract_images = TRUE} and manually delete specific \code{.png} files from the \code{png_folder} and rerun \code{ifcb_prepare_whoi_plankton}.

If \code{convert_filenames = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}, filenames in the \code{"IFCBxxx_YYYY_DDD_HHMMSS"} format (used by IFCB1-6)
will be converted to \code{IYYYYMMDDTHHMMSS_IFCBXXX}, ensuring compatibility with blob extraction in \code{ifcb-analysis} (Sosik & Olson, 2007), which identified the old \code{.adc} format by the first letter of the filename.

If \code{convert_adc = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} and \code{convert_filenames = TRUE} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}, the \code{"IFCBxxx_YYYY_DDD_HHMMSS"} format will instead be converted to
\code{DYYYYMMDDTHHMMSS_IFCBXXX}. Additionally, \code{.adc} files will be modified to include four empty columns
(PMT-A peak, PMT-B peak, PMT-C peak, and PMT-D peak), aligning them with the structure of modern \code{.adc} files
for full compatibility with \code{ifcb-analysis}.
}
\examples{
\dontrun{
# Download and prepare WHOI-Plankton for the years 2013 and 2014
ifcb_prepare_whoi_plankton(
  years = c("2013", "2014"),
  png_folder = "whoi_plankton/png",
  raw_folder = "whoi_plankton/raw",
  manual_folder = "whoi_plankton/manual",
  class2use_file = "whoi_plankton/config/class2use_whoiplankton.mat"
)
}

}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.

Sosik, H. M., Peacock, E. E. and Brownlee E. F. (2015), Annotated Plankton Images - Data Set for Developing and Evaluating Classification Methods. \doi{10.1575/1912/7341}
}
\seealso{
\url{https://hdl.handle.net/1912/7341}, \url{https://whoigit.github.io/whoi-plankton/} \code{\link{ifcb_merge_manual}} \code{\link{ifcb_download_whoi_plankton}} \code{\link{ifcb_download_dashboard_data}}
}
