% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA2.R
\name{ICA2}
\alias{ICA2}
\title{Independent Component Analysis (Modern Methods)}
\usage{
ICA2(
  X,
  J,
  algorithm = c("JADE", "AuxICA1", "AuxICA2", "IPCA", "SIMBEC", "AMUSE", "SOBI", "FOBI",
    "ProDenICA", "RICA"),
  num.iter = NULL,
  thr = 1e-10,
  r_list = NULL,
  omega_for_each_r = NULL,
  a_r_for_each_r = NULL,
  tau_list = NULL,
  num_bins = NULL,
  alpha = NULL,
  num_epoch = NULL,
  verbose = FALSE
)
}
\arguments{
\item{X}{A matrix}

\item{J}{Rank parameter to decompose}

\item{algorithm}{The decomposition algorithm (Default: "JADE")}

\item{num.iter}{The number of iteration}

\item{thr}{The threshold to terminate the iteration (Default: 1E-10)}

\item{r_list}{List of r-th order cumulants used in SIMBEC (Default: NULL)}

\item{omega_for_each_r}{Weight vector of r_list used in SIMBEC (Default: NULL)}

\item{a_r_for_each_r}{Parameter vector to specify the shape of partial activation function in SIMBEC (Default: NULL)}

\item{tau_list}{List of lags to consider the auto-correlation used in AMUSE and SOBI (Default: NULL)}

\item{num_bins}{Number of bins for histgram in ProDenICA (Default: NULL)}

\item{alpha}{Learning rate used for gradient descent in RICA (Default: NULL)}

\item{num_epoch}{Number of epoch used for gradient descent in RICA (Default: NULL)}

\item{verbose}{Verbose option}
}
\value{
A list containing the result of the decomposition
}
\description{
The input data is assumed to be a matrix.
ICA decomposes the matrix and extract the components that
are statistically independent each other.
}
\examples{
ICA2
}
