% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decisionDST.R
\name{decisionDST}
\alias{decisionDST}
\title{Decision Rules}
\usage{
decisionDST(mass, criterion, r = 0.5, sDec = 1:nrow(mass),
  D = Dcalculus(nrow(mass)))
}
\arguments{
\item{mass}{The matrix containing the masses. Each column represents a piece of mass.}

\item{criterion}{The decision baseline:

    criterion=1 maximum of the plausibility

    criterion=2 maximum of the credibility

    criterion=3 maximum of the credibility with rejection

    criterion=4 maximum of the pignistic probability

    criterion=5 Appriou criterion (decision onto \eqn{2^\Theta})

    criterion=6 Distance criterion (decision onto a given subset (sDec) of \eqn{2^\Theta})}

\item{r}{The parameter in BayesianMass function. If criterion 5 is used, it should be given. 
Otherwise it will be set to the default value 0.5.}

\item{sDec}{The parameter for the set on which we want to decide. It should be a subset of {1,2,...,\eqn{2^n}}, where \eqn{n} is the number of elements in \eqn{\Theta}. If criterion 6 is used, it should be given; Otherwise it will be set as the default value \eqn{2^\Theta}}

\item{D}{The parameter for the used matrix in Jousselme distance. If criterion 6 is used, it should be given. Otherwise it will be  set as default
Otherwise it will be calculated.}
}
\value{
The decision vector. E.g., in classification problem, class labels.
}
\description{
Different rules for making decisions in the framework of belief functions
}
\examples{
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
m3=c(0.1,0.2, 0, 0.1, 0.1, 0.1, 0, 0.3);

m3d=discounting(m3,0.95);

M_comb_Smets=DST(cbind(m1,m2,m3d),1);
M_comb_PCR6=DST(cbind(m1,m2),8);

class_fusion=decisionDST(M_comb_Smets,1)
class_fusion=decisionDST(M_comb_PCR6,1)
class_fusion=decisionDST(M_comb_Smets,5,0.5)
class_fusion=decisionDST(cbind(M_comb_Smets,M_comb_PCR6),1)
sDec<-c(2,3,4)
class_fusion=decisionDST(M_comb_Smets,6, sDec = sDec)

}
