% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modalities_functions.R
\name{regroupModalities}
\alias{regroupModalities}
\title{Regroup elements of a vector}
\usage{
regroupModalities(column, regroupMatrix, modalities = NULL)
}
\arguments{
\item{column}{Column vector which values are going to be replaced}

\item{regroupMatrix}{Bounds of the values to regroup under the same modality}

\item{modalities}{Specify the values of the modalities to use. Must match number of rows
of regroupMatrix
If not specified, replacement modalities will be 1:length(column)}
}
\value{
Column vector with regrouped modalities
}
\description{
Regroup the contiguuous elements of a vector under a single value. Which elements should
be regrouped is indicated by the rows of a matrix. Output vector is NOT a factor.
}
\examples{
regroupModalities(c(1:20), rbind(c(0,5),c(6,18),c(19,Inf)))
# Returns : [1] 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 3 3
}

