% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{icd_filter_poa}
\alias{icd_filter_poa}
\alias{icd_filter_poa_no}
\alias{icd_filter_poa_not_no}
\alias{icd_filter_poa_not_yes}
\alias{icd_filter_poa_yes}
\title{Filters data frame based on present-on-arrival flag}
\usage{
icd_filter_poa(x, poa_name = "poa", poa = icd9PoaChoices)

icd_filter_poa_yes(x, poa_name = "poa")

icd_filter_poa_no(x, poa_name = "poa")

icd_filter_poa_not_no(x, poa_name = "poa")

icd_filter_poa_not_yes(x, poa_name = "poa")
}
\arguments{
\item{x}{input vector of ICD codes}

\item{poa_name}{The name of column in the data frame which contains the
Present On Arrival (POA) flag. The flag itself is a single character, typically
one of "Y", "N", "E", "X", "U" or empty.}

\item{poa}{single character value, being one of \code{Yes}, \code{No},
\code{NotYes}, and \code{NotNo}, indicating whether to account for
comorbidities flagged as present-on-arrival. This is not a simple flag,
because many codes are exempt, unspecified, or unknown. The intermediate
codes, such as "exempt", "unknown" and \code{NA} mean that "yes" is not the
same as "not no."}
}
\description{
Present On Arrival (POA) is not a simple flag, since many codes are exempt,
unspecified, or unknown. Therefore, two options are given: get all the
comorbidities where the POA flag was definitely negative, coded as 'N' or
definitely positive and coded as 'Y'. Negating one set won't give the other set
unless all codes were either Y or N.
}
\section{Functions}{
\itemize{
\item \code{icd_filter_poa_yes}: Select rows where Present-on-Arrival flag is
explicitly 'Yes.'

\item \code{icd_filter_poa_no}: Select rows where Present-on-Arrival flag is
explicitly 'No.'

\item \code{icd_filter_poa_not_no}: Select rows where Present-on-Arrival flag is
anything but 'No.' This includes unknown, exempt, other codes, and of
course all those marked 'Yes.'

\item \code{icd_filter_poa_not_yes}: Select rows where Present-on-Arrival flag is
anything but 'Yes.' This would group exempt, unknown and other codes under
'Not POA' which is unlikely to be a good choice, since exempt codes, of
which there are a quite large number, tend to describe chronic or
out-of-hospital characteristics.
}}
\examples{
\dontrun{
# using magrittr is beautiful:
library(magrittr, warn.conflicts = FALSE, quietly = TRUE)
myData <- data.frame(
  visit_id = c("v1", "v2", "v3", "v4"),
  diag = c("39891", "39790", "41791", "4401"),
  poa = c("Y", "N", NA, "Y"),
  stringsAsFactors = FALSE
)
myData \%>\% icd9FilterPoaNotNo() \%>\% icd9ComorbidAhrq
# can fill out named fields also:
myData \%>\% icd9FilterPoaYes(poa_name="poa") \%>\%
  icd_comorbid_ahrq(icd_name = "diag", visit_name = "visit_id", short_code = TRUE)
# can call the core icd9Comorbid function with an arbitrary mapping
myData \%>\%
  icd_filter_poa_yes \%>\%
  icd_comorbid(icd_name = "diag", visit_name = "visit_id",
    map = icd9_map_quan_elix, short_mapping = TRUE)
}
}
\keyword{manip}

