% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R
\name{icd_children}
\alias{icd_children}
\alias{icd_children.character}
\alias{icd_children.icd10}
\alias{icd_children.icd10cm}
\alias{icd_children.icd9}
\title{Get children of ICD codes}
\usage{
icd_children(x, ...)

\method{icd_children}{character}(x, ...)

\method{icd_children}{icd9}(x, short_code = icd_guess_short(x),
  defined = TRUE, billable = FALSE, ...)

\method{icd_children}{icd10}(x, short_code = icd_guess_short(x), defined,
  billable = FALSE, ...)

\method{icd_children}{icd10cm}(x, short_code = icd_guess_short(x), defined,
  billable = FALSE, ...)
}
\arguments{
\item{x}{data, e.g. character vector of ICD codes.}

\item{...}{arguments passed on to other functions}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{defined}{single logical value, whether returned codes should only
include those which have definitions. Definition is based on the ICD
version being used, e.g. ICD-9-CM, the WHO version of ICD-10, or other.}

\item{billable}{single logical value, whether to limit return codes also by
whether they are billable, i.e. leaf nodes. This is really only designed
for use with ICD-9-CM, ICD-10-CM etc, since the WHO versions are not
designed for billing, but for public health and death reporting.}
}
\description{
Expand ICD codes to all possible sub-codes, optionally limiting to those
codes which are \emph{defined} or \emph{billable} (leaf nodes).
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Get child codes, guessing ICD version and short
versus decimal format

\item \code{icd9}: Get children of ICD-9 codes

\item \code{icd10}: Get children of ICD-10 codes (warns because this
only applies to ICD-10-CM for now).

\item \code{icd10cm}: Get children of ICD-10-CM codes
}}
\examples{
library(magrittr, warn.conflicts = FALSE, quietly = TRUE) # optional

# no children other than self
icd_children("10201", short_code = TRUE, defined =FALSE)

# guess it was ICD-9 and a short, not decimal code
icd_children("0032")

# empty because 102.01 is not meaningful
icd_children("10201", short_code = TRUE, defined =TRUE)
icd_children("003", short_code = TRUE, defined =TRUE) \%>\%
  icd_explain(condense = FALSE, short_code = TRUE)

icd_children(short_code = FALSE, "100.0")
icd_children(short_code = FALSE, "100.00")
icd_children(short_code = FALSE, "2.34")
}
\seealso{
Other ICD-9 ranges: \code{\link{icd_condense}},
  \code{\link{icd_expand_minor}},
  \code{\link{icd_expand_range}}
}
\keyword{internal}
\keyword{manip}

