% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9DecimalToShort}
\alias{icd9DecimalToShort}
\title{convert between icd9 decimal and short formats}
\usage{
icd9DecimalToShort(icd9Decimal, leadingZeroes = T)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{leadingZeroes}{logical whether to fill out major part with zeroes, or
just truncate to the left. If E code, there is no valid code since
E800-E999 is defined. V codes could be V0x or Vxx, and so could be zero
padded.}
}
\value{
character vector of converted ICD-9 codes
}
\description{
converted decimal ICD9 code, e.g. 123.45 to 'short' e.g. 12345
  non-decimal format
}
\keyword{manip}

