% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9Explain}
\alias{icd9Explain}
\alias{icd9Explain.character}
\alias{icd9Explain.list}
\title{explain ICD9 codes}
\usage{
icd9Explain(icd9Decimal)

\method{icd9Explain}{list}(icd9Decimal)

\method{icd9Explain}{character}(icd9Decimal)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
data frame, or list of data frames, with fields for ICD9 code, name
  and description, derived from datamart lookup table
}
\description{
convert full format (123.45 style) ICD9 codes into the name and
  description for human review there are official ICD9-CM data tables, not
  with conversion to decimal notation, but to the textual format.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: explain alll ICD-9 codes in a list of vectors

\item \code{character}: explain character vector of ICD-9 codes
}}
\note{
TODO: it will be useful to have S3 ICD-9 short and long classes for
  situations like this where we could easily dispatch on short or long type,
  or even use a print.icd9decimal or print.icd9short S3 method to display
  ICD-9 codes.
}
\examples{
icd9Explain(ahrqComorbid[[1]][1:3])
}
\references{
\url{http://www.stata.com/help.cgi?icd9}
}
\seealso{
package comorbidities
}

