% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9PartsRecompose}
\alias{icd9PartsRecompose}
\alias{icd9PartsToDecimal}
\alias{icd9PartsToShort}
\title{recompose major and minor parts into icd9 codes}
\usage{
icd9PartsRecompose(major = NULL, minor = NULL, parts = NULL, sep)

icd9PartsToShort(major = NULL, minor = NULL, parts = NULL)

icd9PartsToDecimal(major = NULL, minor = NULL, parts = NULL)
}
\arguments{
\item{major}{character vector of 'major' part of ICD-9 codes, i.e. that part
which falls before the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be the first three characters (with leading
zeroes), and includes V or E prefix. xyz}

\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be xyz, even when x and y are zero, thus the
last two characters represent the 'minor' part, in this case.)}

\item{parts}{data.frame with major and minor fields. This can be given
instead of major and minor vectors}

\item{sep}{character separator, usually "" or "." corresponding to 'short' or 'decimal' ICD-9 codes}
}
\value{
character vector. Deliberately returns zero-padded major, because
  otherwise we are creating ambiguous codes (even if we know what we mean)
}
\description{
internal function which checks vector lengths to avoid
  unintentional recycling of vectors when lengths differ. Length of one is
  fine for major or minor.
}
\keyword{internal}

