% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ValidMajor}
\alias{icd9ValidMajor}
\alias{icd9ValidMajorE}
\alias{icd9ValidMajorN}
\alias{icd9ValidMajorV}
\title{validate a major part}
\usage{
icd9ValidMajor(major)

icd9ValidMajorN(major)

icd9ValidMajorV(major)

icd9ValidMajorE(major)
}
\arguments{
\item{major}{character vector of 'major' part of ICD-9 codes, i.e. that part
which falls before the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be the first three characters (with leading
zeroes), and includes V or E prefix. xyz}
}
\description{
validation for just the 'major' part of an ICD-9 code. This can in fact be provided as a numeric, since there is no ambiguity. Numeric-only codes should be one to three digitis, V codes are followed by one or two digits, and E codes always by three digits between 800 and 999.
}
\seealso{
Other ICD9 validation: \code{\link{icd9GetInvalidMappingDecimal}},
  \code{\link{icd9GetInvalidMappingShort}},
  \code{\link{icd9ValidMapping}},
  \code{\link{icd9ValidMappingDecimal}},
  \code{\link{icd9ValidMappingShort}};
  \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{icd9ValidNaWarnStop}},
  \code{\link{icd9ValidNaWarnStopDecimal}},
  \code{\link{icd9ValidNaWarnStopMajor}},
  \code{\link{icd9ValidNaWarnStopShort}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}}; \code{\link{icd9Valid}};
  \code{\link{stopIfInvalidIcd9}},
  \code{\link{warnIfInvalidIcd9}}
}

