% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFishStockReferencePoints.R
\name{getFishStockReferencePoints}
\alias{getFishStockReferencePoints}
\title{Get Reference Points}
\usage{
getFishStockReferencePoints(key)
}
\arguments{
\item{key}{the unique identifier of the stock assessment}
}
\value{
A data frame.
}
\description{
Get biological reference points for all stocks in a given assessment year.
}
\examples{
stocklist <- getListStocks(2016)
id <- grep("cod-2224", stocklist$FishStockName)
stocklist[id,]
key <- stocklist$AssessmentKey[id]
refpts <- getFishStockReferencePoints(key)
refpts

}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getSummaryTable}} get a list of
  stocks and summary results.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar and Scott Large.
}
