% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make}
\alias{make}
\title{Run TAF Script If Needed}
\usage{
make(recipe, prereq, target, debug = FALSE)
}
\arguments{
\item{recipe}{TAF script filename.}

\item{prereq}{one or more underlying data files, required by the TAF script.}

\item{target}{one output file, produced by the TAF script.}

\item{debug}{whether to show a diagnostic table of files and time last
modified.}
}
\value{
Invisible \code{TRUE} or \code{FALSE}, indicating whether the script was run.
}
\description{
Run a TAF script if underlying data files have changed, otherwise do nothing.
}
\examples{
\dontrun{
make("model.R", "input/input.txt", "model/results.txt")
}

}
\seealso{
\code{\link{sourceTAF}} runs a TAF script.

\code{\link{sourceAtoZ}} runs all TAF scripts in a directory.

\code{\link{icesTAF-package}} gives an overview of the package.
}
