% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tafpng.R
\name{tafpng}
\alias{tafpng}
\title{PNG Device}
\usage{
tafpng(filename, width = 800, height = 600, pointsize = 22, ...)
}
\arguments{
\item{filename}{image filename.}

\item{width}{image width.}

\item{height}{image height.}

\item{pointsize}{text size.}

\item{\dots}{passed to \code{png}.}
}
\description{
Open PNG graphics device to create an image file inside the TAF \verb{report}
folder.
}
\details{
The \code{filename} can be passed without the preceding
\verb{report/}, and without the \verb{.png} filename extension.

Specifically, the function prepends \verb{"report/"} to the filename if the
filename does not contain a \verb{"/"} separator and the working directory is
not \verb{"report"}. The function appends \verb{".png"} to the filename if it
does not already have that filename extension.

This automatic filename manipulation can be bypassed by using the \code{png}
function directly.
}
\note{
A simple convenience function to shorten
\preformatted{png("report/myplot.png", width=800, height=600, pointsize=22)}
to
\preformatted{tafpng("myplot")}
}
\examples{
\dontrun{
tafpng("myplot")
plot(1)
dev.off()
}

}
\seealso{
\code{\link{png}} is the underlying function used to open a PNG graphics
device.

\code{\link{icesTAF-package}} gives an overview of the package.
}
