#' Write DLS3.2 Results to File
#'
#' Write results from the \code{DLS3.2} advisory method to a file.
#'
#' @param x a list generated by the \code{DLS3.2} function.
#' @param file a filename.
#'
#' @note The resulting text file has Dos line endings (CRLF).
#'
#' @seealso
#' \code{\link{read.dls}} reads \code{DLS3.2} results from a file back into R.
#'
#' \code{\link[icesAdvice]{DLS3.2}} in the \pkg{icesAdvice} package can be used
#' to calculate catch advice for data-limited stocks (DLS).
#'
#' \code{\link{icesTAF-package}} gives an overview of the package.
#'
#' @examples
#' \dontrun{
#' survey <- data.frame(year=2001:2010, randu[1:10,])
#' dls <- icesAdvice::DLS3.2(1000, survey$y)
#'
#' write.dls(dls, "dls.txt")
#' read.dls("dls.txt")
#'
#' file.remove("dls.txt")
#' }
#'
#' @export

write.dls <- function(x, file="")
{
  nn <- names(x)
  write(nn[1], file)
  write(x[[1]], file, append=TRUE)
  for(i in 2:length(x))
  {
    write("", file, append=TRUE)
    write(nn[i], file, append=TRUE)
    write(x[[i]], file, ncolumns=10, append=TRUE)
  }
  if(file != "")
    unix2dos(file)
}
