% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAll.R
\name{makeAll}
\alias{makeAll}
\title{Run All TAF Scripts as Needed}
\usage{
makeAll(...)
}
\arguments{
\item{\dots}{passed to \code{\link{makeTAF}}.}
}
\value{
Logical vector indicating which scripts were run.
}
\description{
Run core TAF scripts that have changed, or if previous steps were rerun.
}
\note{
TAF scripts that will be run as needed: \verb{data.R}, \verb{input.R},
\verb{model.R}, \verb{output.R}, and \verb{report.R}.

If a \verb{begin.R} script exists, it is ignored.
}
\examples{
\dontrun{
makeAll()
}

}
\seealso{
\code{\link{source}} runs any R script, \code{\link{sourceTAF}} is more
convenient for running a TAF script, and \code{\link{sourceAll}} runs all TAF
scripts.

\code{\link{make}}, \code{\link{makeTAF}}, and \code{\link{makeAll}} are
similar to the \code{source} functions, except they avoid repeating tasks
that have already been run.

\code{\link{icesTAF-package}} gives an overview of the package.
}
