% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceTAF.R
\name{sourceTAF}
\alias{sourceTAF}
\title{Run TAF Script}
\usage{
sourceTAF(script, rm = FALSE, clean = TRUE, quiet = FALSE)
}
\arguments{
\item{script}{script filename.}

\item{rm}{whether to remove all objects from the global environment before
and after the script is run.}

\item{clean}{whether to \code{\link{clean}} the target directory before
running the script.}

\item{quiet}{whether to suppress messages reporting progress.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the script ran without
errors.
}
\description{
Run a TAF script and return to the original directory.
}
\details{
The default value of \code{rm = FALSE} is to protect users from accidental
loss of work, but the TAF server always runs with \code{rm = TRUE} to make
sure that only files, not objects, are carried over between scripts.

Likewise, the TAF server runs with \code{clean = TRUE} to make sure that the
script starts with a clean directory. The target directory of a TAF script
has the same filename prefix as the script: \verb{data.R} creates \file{data}
etc.
}
\note{
Commands within a script (such as \code{setwd}) may change the working
directory, but \code{sourceTAF} guarantees that after running a script, the
working directory reported by \code{getwd()} is the same before and after
running a script.
}
\examples{
\dontrun{
write("print(pi)", "script.R")
source("script.R")
sourceTAF("script.R")
file.remove("script.R")
}

}
\seealso{
\code{\link{source}} is the base function to run R scripts.

\code{\link{makeTAF}} runs a TAF script if needed.

\code{\link{sourceAll}} runs all TAF scripts in a directory.

\code{\link{icesTAF-package}} gives an overview of the package.
}
