% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAF.R
\name{taf-reexports}
\alias{taf-reexports}
\alias{makeAll}
\alias{taf.install}
\alias{parse.repo}
\alias{taf2long}
\alias{utf8.to.latin1}
\alias{download}
\alias{write.taf}
\alias{flr2taf}
\alias{get.remote.sha}
\alias{taf.bootstrap}
\alias{long2taf}
\alias{xtab2taf}
\alias{source.taf}
\alias{ds.file}
\alias{div}
\alias{detach.packages}
\alias{rnd}
\alias{taf2xtab}
\alias{ds.package}
\alias{long2xtab}
\alias{os.linux}
\alias{taf.png}
\alias{os.macos}
\alias{os}
\alias{period}
\alias{tt}
\alias{clean.data}
\alias{zoom.trellis}
\alias{zoom}
\alias{unix2dos}
\alias{dos2unix}
\alias{mkdir}
\alias{convert.spaces}
\alias{lim}
\alias{is.r.package}
\alias{clean.software}
\alias{taf.boot.path}
\alias{sourceAll}
\alias{plus}
\alias{taf.sources}
\alias{msg}
\alias{process.entry}
\alias{taf.data.path}
\alias{download.github}
\alias{deps}
\alias{taf.session}
\alias{os.unix}
\alias{os.windows}
\alias{xtab2long}
\alias{draft.data}
\alias{read.taf}
\alias{clean}
\alias{taf.libPaths}
\alias{draft.software}
\alias{sourceDir}
\alias{taf.boot}
\alias{file.encoding}
\alias{latin1.to.utf8}
\alias{clean.library}
\alias{tafpng}
\alias{sourceTAF}
\alias{taf2html}
\alias{source.all}
\alias{extract.subdir}
\alias{taf.library}
\alias{read.bib}
\alias{stamp.description}
\alias{make.all}
\alias{make.taf}
\alias{make}
\alias{line.endings}
\alias{already.in.taf.library}
\alias{taf.unzip}
\alias{process.bibfile}
\alias{cp}
\alias{makeTAF}
\alias{rmdir}
\alias{source.dir}
\alias{sam2taf}
\alias{taf.skeleton}
\title{Functions re-exported from the TAF package}
\usage{
makeAll(...)

taf.install(targz = NULL, lib = "bootstrap/library", quiet = FALSE)

parse.repo(repo)

taf2long(x, names = c("Year", "Age", "Value"))

utf8.to.latin1(file, force = FALSE)

download(url, dir = ".", mode = "wb", chmod = file_ext(url) == "",
  destfile = file.path(dir, basename(url)), quiet = TRUE, ...)

write.taf(x, file = NULL, dir = NULL, quote = FALSE, row.names = FALSE,
  fileEncoding = "UTF-8", underscore = TRUE, ...)

flr2taf(x, colname = "Value")

get.remote.sha(owner, repo, ref, seven = TRUE)

taf.bootstrap(...)

long2taf(x)

xtab2taf(x, colname = "Year")

source.taf(script, rm = FALSE, clean = TRUE, detach = FALSE,
  taf = NULL, quiet = FALSE)

ds.file(package, author, year, title, version, source)

div(x, cols, by = 1000, grep = FALSE, ...)

detach.packages(quiet = FALSE)

rnd(x, cols, digits = 0, grep = FALSE, ...)

taf2xtab(x)

ds.package(package, author, year, title, version, source)

long2xtab(x)

os.linux()

taf.png(filename, width = 1600, height = 1200, res = 200, ...)

os.macos()

os()

period(x, y = NULL)

tt(x, column = FALSE)

clean.data(folder = "bootstrap/data", quiet = FALSE, force = FALSE)

\method{zoom}{trellis}(x, size = 1, main = 1.2 * size, lab = size,
  axis = size, strip = size, sub = 0.9 * size, legend = 0.9 * size,
  splom = 0.9 * size, ...)

zoom(x, ...)

unix2dos(file)

dos2unix(file)

mkdir(path)

convert.spaces(file, sep = "_")

lim(x, mult = 1.1)

is.r.package(targz, spec = NULL, warn = TRUE)

clean.software(folder = "bootstrap/software", quiet = FALSE,
  force = FALSE)

taf.boot.path(..., fsep = .Platform$file.sep)

sourceAll(...)

plus(x)

taf.sources(type)

msg(...)

process.entry(bib, quiet = FALSE, force = FALSE, clean = FALSE)

taf.data.path(..., fsep = .Platform$file.sep)

download.github(repo, dir = ".", quiet = FALSE)

deps(path = ".", base = FALSE, installed = TRUE, available = TRUE,
  list = FALSE)

taf.session(sort = FALSE, details = FALSE)

os.unix()

os.windows()

xtab2long(x, names = c("Year", "Age", "Value"))

draft.data(originator = NULL, year = format(Sys.time(), "\%Y"),
  title = NULL, period = NULL, access = "Public", source = NULL,
  file = "", append = FALSE, data.files = dir("bootstrap/initial/data"),
  data.scripts = dir("bootstrap", pattern = "\\\\.R$"))

read.taf(file, check.names = FALSE, stringsAsFactors = FALSE,
  fileEncoding = "UTF-8", ...)

clean(dirs = c("data", "model", "output", "report"), force = FALSE)

taf.libPaths(remove = FALSE)

draft.software(package, author = NULL, year = NULL, title = NULL,
  version = NULL, source = NULL, file = "", append = FALSE)

sourceDir(...)

taf.boot(software = TRUE, data = TRUE, clean = TRUE, force = FALSE,
  taf = NULL, quiet = FALSE)

file.encoding(file)

latin1.to.utf8(file, force = FALSE)

clean.library(folder = "bootstrap/library", quiet = FALSE, force = FALSE)

tafpng(...)

sourceTAF(...)

taf2html(x, file = "", align = "", header = align,
  digits = getOption("digits"), center = "style=\\"text-align:center\\"",
  left = "style=\\"text-align:left\\"",
  right = "style=\\"text-align:right\\"", append = FALSE)

source.all(...)

extract.subdir(targz, subtargz, subdir)

taf.library(package, messages = FALSE, warnings = FALSE)

read.bib(file)

stamp.description(targz, spec, sha.full)

make.all(...)

make.taf(script, ...)

make(recipe, prereq, target, include = TRUE, engine = source,
  debug = FALSE, force = FALSE, recon = FALSE, ...)

line.endings(file)

already.in.taf.library(targz, lib)

taf.unzip(zipfile, files = NULL, exdir = ".", unzip = NULL, ...)

process.bibfile(type, clean = TRUE, quiet = FALSE)

cp(from, to, move = FALSE, ignore = FALSE, overwrite = TRUE,
  quiet = TRUE)

makeTAF(...)

rmdir(path, recursive = FALSE)

source.dir(dir, pattern = "\\\\.[r|R]$", all.files = FALSE,
  recursive = FALSE, quiet = TRUE, ...)

sam2taf(x, colname = NULL, year = TRUE)

taf.skeleton(path = ".", force = FALSE, pkgs = "icesTAF")
}
\description{
These functions are re-exported from the TAF package.
}
\details{
Follow the links below to see the documentation.
[TAF::makeAll], [TAF::taf.install], [TAF::parse.repo], [TAF::taf2long], [TAF::utf8.to.latin1], [TAF::download], [TAF::write.taf], [TAF::flr2taf], [TAF::get.remote.sha], [TAF::taf.bootstrap], [TAF::long2taf], [TAF::xtab2taf], [TAF::source.taf], [TAF::ds.file], [TAF::div], [TAF::detach.packages], [TAF::rnd], [TAF::taf2xtab], [TAF::ds.package], [TAF::long2xtab], [TAF::os.linux], [TAF::taf.png], [TAF::os.macos], [TAF::os], [TAF::period], [TAF::tt], [TAF::clean.data], [TAF::zoom.trellis], [TAF::zoom], [TAF::unix2dos], [TAF::dos2unix], [TAF::mkdir], [TAF::convert.spaces], [TAF::lim], [TAF::is.r.package], [TAF::clean.software], [TAF::taf.boot.path], [TAF::sourceAll], [TAF::plus], [TAF::taf.sources], [TAF::msg], [TAF::process.entry], [TAF::taf.data.path], [TAF::download.github], [TAF::deps], [TAF::taf.session], [TAF::os.unix], [TAF::os.windows], [TAF::xtab2long], [TAF::draft.data], [TAF::read.taf], [TAF::clean], [TAF::taf.libPaths], [TAF::draft.software], [TAF::sourceDir], [TAF::taf.boot], [TAF::file.encoding], [TAF::latin1.to.utf8], [TAF::clean.library], [TAF::tafpng], [TAF::sourceTAF], [TAF::taf2html], [TAF::source.all], [TAF::extract.subdir], [TAF::taf.library], [TAF::read.bib], [TAF::stamp.description], [TAF::make.all], [TAF::make.taf], [TAF::make], [TAF::line.endings], [TAF::already.in.taf.library], [TAF::taf.unzip], [TAF::process.bibfile], [TAF::cp], [TAF::makeTAF], [TAF::rmdir], [TAF::source.dir], [TAF::sam2taf]
}
\keyword{internal}
