#' @docType package
#'
#' @name icesVMS-package
#'
#' @aliases icesVMS
#'
#' @title Functions to link to the ICES VMS and logbook database web services.
#'
#' @description
#' Functions to link to the ICES VMS and logbook database web services to allow
#' users to download summaries and data products from the ICES VMS and logbook database.
#'
#' @details
#'
#' \emph{Download data:}
#' \tabular{ll}{
#'   \code{\link{get_benthis_parameters}}     \tab download gear contact model parameters\cr
#'   \code{\link{get_metier_lookup}} \tab download metier to gear category lookup table\cr
#'   \code{\link{get_vms}}         \tab download VMS data
#' }
#'
#' @author Colin Millar.
#'
#' @references
#' ICES VMS and Logbook Database web services: \url{https://data.ices.dk/vms/webservices}.
#'

NA
