% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCodeType.R
\name{findCodeType}
\alias{findCodeType}
\title{Find a Key}
\usage{
findCodeType(code, date = NULL, regex = TRUE, full = FALSE)
}
\arguments{
\item{code}{a code name, e.g. Gear Type, or DATRAS to find all DATRAS related codes.}

\item{date}{restrict output to code types modified after a given date in
yyyy-mm-dd format, e.g. "2010-12-01"}

\item{regex}{whether to match the stock name as a regular expression.}

\item{full}{whether to return a data frame with all stock list columns.}
}
\value{
A vector of keys (default) or a data frame if full is TRUE.
}
\description{
Find a lookup key corresponding to a code type.
}
\examples{
\donttest{
findCodeType("worms")

findCodeType("DATRAS", full = TRUE)

findCodeType("DATRAS", full = TRUE, date = "2010-01-01")
}
}
\seealso{
\code{\link{getCodeTypeList}} gets a list of code types.

\code{\link{icesVocab-package}} gives an overview of the package.
}
