% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{ichimoku}
\alias{ichimoku}
\alias{ichimoku.ichimoku}
\alias{ichimoku.xts}
\alias{ichimoku.ArrowTabular}
\alias{ichimoku.data.frame}
\alias{ichimoku.matrix}
\alias{ichimoku.default}
\title{ichimoku}
\usage{
ichimoku(x, ...)

\method{ichimoku}{ichimoku}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{xts}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{ArrowTabular}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{data.frame}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{matrix}(x, ticker, periods = c(9L, 26L, 52L), ...)

\method{ichimoku}{default}(x, ticker, periods = c(9L, 26L, 52L), ...)
}
\arguments{
\item{x}{a data.frame or other compatible object, which includes xts,
data.table, tibble, matrix, and Arrow tabular formats.}

\item{...}{additional arguments, for instance 'holidays', passed along to
\code{\link{tradingDays}} for calculating the future cloud on daily data.}

\item{ticker}{(optional) specify a ticker to identify the instrument,
otherwise this is set to the name of the input object 'x'.}

\item{periods}{[default c(9L, 26L, 52L)] a vector defining the length of
periods used for the cloud. This parameter shoud not normally be modified
as using other values would be invalid in the context of traditional
Ichimoku analysis.}
}
\value{
An ichimoku object is returned with S3 classes of 'ichimoku', 'xts'
    and 'zoo'.
}
\description{
Create an ichimoku object containing values for all components of the
    Ichimoku Kinko Hyo cloud chart. The object encapsulates a date-time
    index, OHLC pricing data, candle direction, the cloud lines Tenkan-sen,
    Kijun-sen, Senkou span A, Senkou span B and Chikou span, as well as
    values for the cloud top and cloud base.
}
\details{
Calling an ichimoku object automatically invokes its print method,
    which will by default produce a printout of the data to the console as
    well as a static plot of the cloud chart to the graphical device.

    For further options, please use plot() on the returned ichimoku object to
    pass further arguments for customising the chart. Use iplot() for
    interactive charting.

    Where an ichimoku object is passed to ichimoku(), the ichimoku object is
    re-calculated using the OHLC pricing data contained within.
}
\section{Object Specification}{


    Index:
    \itemize{
        \item{\code{index(object)}:} {date-time index [POSIXct]}
     }
    Columns [numeric]:
    \itemize{
        \item{\code{object$open}:} {opening price}
        \item{\code{$high}:} {high price}
        \item{\code{$low}:} {low price}
        \item{\code{$close}:} {closing price}
        \item{\code{$cd}:} {candle direction (-1 = down, 0 = flat, 1 = up)}
        \item{\code{$tenkan}:} {Tenkan-sen}
        \item{\code{$kijun}:} {Kijun-sen}
        \item{\code{$senkouA}:} {Senkou span A}
        \item{\code{$senkouB}:} {Senkou span B}
        \item{\code{$chikou}:} {Chikou span}
        \item{\code{$cloudT}:} {cloud Top (max of senkouA, senkouB)}
        \item{\code{$cloudB}:} {cloud Base (min of senkouA, senkouB)}
     }
    Attributes:
    \itemize{
        \item{\code{attributes(object)$periods}:} { parameters used to
        calculate the cloud [integer vector of length 3]}
        \item{\code{$periodicity}:} { periodicity of the
        data in seconds [numeric]}
        \item{\code{$ticker}:} { instrument identifier [character]}
     }
}

\section{Working with ichimoku objects}{

    An ichimoku object inherits the 'xts' and 'zoo' classes. For convenience,
    the following functions are re-exported by ichimoku:

    \emph{from 'zoo':}
     \itemize{
        \item{\code{index()}:} { to extract the index of an ichimoku object}
        \item{\code{coredata()}:} { to extract the columns of an ichimoku
        object as a numeric matrix}
     }

     \emph{from 'xts':}
     \itemize{
        \item{\code{xts()}:} { to create an 'xts' object from data and a
        date-time index use \code{xts(data, index)}}
     }

     Additional methods are available by loading the 'xts' package.
}

\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data)
ichimoku(sample_ohlc_data, ticker = "TKR", periods = c(9L, 26L, 52L))

}
