% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-attributes.R
\name{trishape}
\alias{trishape}
\alias{trishape,trigrid-method}
\alias{trishape,hexagrid-method}
\title{Shape distortions of the triangular faces and subfaces}
\usage{
trishape(gridObj)

\S4method{trishape}{trigrid}(gridObj)

\S4method{trishape}{hexagrid}(gridObj)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}}, \code{\link{hexagrid}}) Object.}
}
\value{
A named \code{numeric} vector, one value for every face of the grid.
}
\description{
This function will return a value that is proportional to the irregularity of a triangonal face or subface. The ratio of the lengths of the shortest and the longest edges.
}
\details{
The value is exactly \code{1} for an equilateral triangle, and becomes \code{0} as one of the edges approach \code{0}.
}
\examples{
g <- trigrid(3)
shape <- trishape(g)


}
