% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{imTest}
\alias{imTest}
\title{Hypothesis testing}
\usage{
imTest(bs.rst, quantiles = c(0.025, 0.975))
}
\arguments{
\item{bs.rst}{A class \code{IDEM.BOOT} result list from
\code{\link{imBs}} for bootstrap analysis}

\item{quantiles}{Quantiles for extracting bootstrap confidence intervals}
}
\value{
A class \code{IDEM.TEST} containing two datasets

\describe{

\item{list.var}{List of parameters}

\item{theta}{ With columns

\itemize{

\item \code{Delta0}: Sensitivity parameter for control arm,
\item \code{Delta1}: Sensitivity parameter for intervention arm
\item \code{Theta}: Estimated \eqn{\theta}
\item \code{SD}: Standard deviation
\item \code{PValue}: p-value
}}

\item{quantiles}{With columns

\itemize{

\item \code{Delta}:Sensitivity parameter
\item \code{TRT}:Treatment arm
\item \code{Q}: Quantiles of the composite endpoint to be estimated
\item \code{Quant}: Estimation
\item \code{LB}: Lower bound of the specified confidence interval
\item \code{UB}: Upper bound of the specified confidence interval
}}
}
}
\description{
Hypothesis testing using the estimation for the original dataset and
Summarize Boostrap analysis results
}
\examples{
\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                  endp=c("Y2"), unitTime="days",
                  trt.label = c("UC+SBT", "SAT+SBT"),
                  cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit   <- imFitModel(abc, lst.var);
rst.imp   <- imImpAll(abc, rst.fit, deltas=c(-0.25,0,0.25),
                      normal=TRUE, chains = 4, iter = 2000, warmup = 1000);
rst.boot  <- imBs(rst.imp, n.boot = 10, n.cores = 5);
rst.final <- imTest(rst.boot);}

}
