% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imImpSingle}
\alias{imImpSingle}
\title{Impute missing data for MCMC convergence checking}
\usage{
imImpSingle(
  dsub,
  fit.rst,
  normal = TRUE,
  chains = 4,
  iter = 5000,
  warmup = 1000,
  control = list(adapt_delta = 0.95),
  ...,
  seed = NULL
)
}
\arguments{
\item{dsub}{original individual subject data}

\item{fit.rst}{A class \code{IDEMFIT} results generated by
\code{\link{imFitModel}}.}

\item{normal}{Logical variable indicating whether normality assumption should
be made for the residuals}

\item{chains}{STAN parameter. Number of Markov chainsm}

\item{iter}{STAN parameter. Number of iterations}

\item{warmup}{STAN parameter. Number of burnin.}

\item{control}{STAN parameter. See \code{rstan::stan} for details.}

\item{...}{other options to call STAN sampling such as \code{thin},
\code{algorithm}. See \code{rstan::sampling} for details.}

\item{seed}{Random seed}
}
\value{
\code{NULL} if there is no missing data in \code{dsub}

Otherwise, return a class \code{IDEMSINGLE} object that contains a list with
components \describe{ \item{dsub}{original data of the subject}
\item{rst.stan}{A \code{stan.fit} class result returned from
\code{rstan::sampling}} \item{complete}{A dataframe with complete data for
the selected subject} }
}
\description{
Call STAN model to impute missing data for an individual subject under
benchmark assumption for MCMC convergence checking
}
\examples{
im.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
im.fit <- imFitModel(im.abc);
im.imp <- imImpSingle(abc[1,], im.fit, chains = 4, iter = 200, warmup = 100);

}
