% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfFileChange.R
\encoding{UTF-8}
\name{psfFileChange}
\alias{psfFileChange}
\alias{psfFileChangeBATCH}
\title{psfFileChange and psfFileChangeBATCH}
\source{
\enumerate{
   \item r - How can I check if a file is empty? - Stack Overflow answered by Konrad Rudolph and edited by Geekuna Matata on Apr 23 2014. See \url{http://stackoverflow.com/questions/23254002/how-can-i-check-if-a-file-is-empty}.
   \item r - Better error message for stopifnot? - Stack Overflow answered by Andrie on Dec 1 2011. See \url{http://stackoverflow.com/questions/8343509/better-error-message-for-stopifnot}.
   \item inside-R: TclInterface {tcltk}. See \url{http://www.inside-r.org/r-doc/tcltk/.Tcl}.
   \item James Wettenhall & Philippe Grosjean, File Open/Save dialogs in R tcltk, December 01, 2015. See \url{http://www.sciviews.org/recipes/tcltk/TclTk-file-open-save-dialogs/}.
   \item Replacing nth line in a text file in R - Stack Overflow answered by Spacedman on Aug 1 2012. See \url{http://stackoverflow.com/questions/11756353/replacing-nth-line-in-a-text-file-in-r}.
   \item r - read csv files and perform function, then bind together - Stack Overflow answered by bjoseph on Jan 8 2015. See \url{http://stackoverflow.com/questions/27846715/read-csv-files-and-perform-function-then-bind-together}.
   \item multiple output filenames in R - Stack Overflow asked and edited by Gabelins on Feb 1 2013. See \url{http://stackoverflow.com/questions/14651594/multiple-output-filenames-in-r}.
   \item r - Regex return file name, remove path and file extension - Stack Overflow answered and edited by Ananda Mahto on Feb 25 20134. See \url{http://stackoverflow.com/questions/15073753/regex-return-file-name-remove-path-and-file-extension/15073919}.
}
}
\usage{
psfFileChange(file = tk_choose.files(default = "", caption =
  "Select file(s) to open & hold down Ctrl to choose more than 1 file", multi =
  TRUE, filters = matrix(c("Text file", ".psf", "Text file", ".PSF"), 4, 2,
  byrow = TRUE)), interactive = TRUE)

psfFileChangeBATCH(path = tk_choose.dir(caption =
  "Select the directory with the .psf files"))
}
\arguments{
\item{file}{Input .psf file(s) to change specific SkewSE, GenSkew, and
SkewOpt information to be selected through a file dialog.}

\item{interactive}{If interactive is TRUE, then the user will select the
filenames(s) to use for saving with the file dialog. In order to select
more than one file, the user must hold down the Ctrl (Control) button
while mouse clicking the chosen files. If interactive is \code{FALSE}, then
the user will select the directory, via the directory dialog, to use for
saving and the original filenames will be used.}

\item{path}{Directory path of .psf files, to be selected through a
directory dialog, to change specific SkewSE, GenSkew, and SkewOpt
information. The user will be asked where to find the .psf files
& then the user will be asked where to save the revised .psf files.}
}
\value{
Revised .psf text file(s)
}
\description{
The .psf file is a script file that records the specifications used to run
the USGS PeakFQ program (\url{http://water.usgs.gov/software/PeakFQ/}) for
a station. psfFileChange and psfFileChangeBATCH modify the original .psf
settings.
}
\details{
psfFileChange searches for a character vector of patterns (SkewSE,
  GenSkew, and SkewOpt) in single or multiple .psf file(s) to replace. If
  the patterns are missing, then the patterns are added to the file(s).
  This is done for a single file or multiple files that the user selects.
  Although these changes are currently pre-determined, future versions may
  allow the user to change particular settings (for example, how
  outliers are handled).

psfFileChangeBATCH searches for a character vector of patterns
  (SkewSE, GenSkew, and SkewOpt) in a directory of .psf files to replace. If
  the patterns are missing, then the patterns are added to the files. This
  is done in a BATCH mode (whole directory of .psf files). Although these
  changes are currently pre-determined, future versions may allow the
  user to change particular settings (for example, how outliers are handled).
}
\examples{
\dontrun{
# Examples to change (a) .psf file(s) interactively and non-interactively
library(ie2misc)
psfFileChange() # default where interactive = TRUE
# Follow the file dialog instructions


# These are the rows that have been added or changed as a result of this function:

# SkewSE 0.361804179633127
# GenSkew 0.0104293904
# SkewOpt Weighted



psfFileChange(interactive = FALSE)
# Follow the file dialog instructions

# These are the rows that have been added or changed as a result of this function:

# SkewSE 0.361804179633127
# GenSkew 0.0104293904
# SkewOpt Weighted



psfFileChangeBATCH() # Follow the file dialog instructions


# These are the rows that have been added or changed as a result of this function:

# SkewSE 0.361804179633127
# GenSkew 0.0104293904
# SkewOpt Weighted
}

}
\author{
Irucka Embry, Anne Hoos
}

