% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_enthalpy.R
\encoding{UTF-8}
\name{sat_enthalpy}
\alias{sat_enthalpy}
\alias{sat_enthalpy2}
\title{Saturated Enthalpy (H)}
\source{
\enumerate{
   \item r - Better error message for stopifnot? - Stack Overflow answered by Andrie on Dec 1 2011. See \url{https://stackoverflow.com/questions/8343509/better-error-message-for-stopifnot}.
   \item How to check file extensions in R - Stack Overflow answered by lebatsnok on May 17 2014. See \url{https://stackoverflow.com/questions/23713284/how-to-check-file-extensions-in-r}.
   \item RDocumentation: TclInterface {tcltk}. See \url{https://www.rdocumentation.org/packages/tcltk/versions/3.3.1}.
   \item James Wettenhall & Philippe Grosjean, File Open/Save dialogs in R tcltk, December 01, 2015. See \url{https://web.archive.org/web/20160521051207/http://www.sciviews.org/recipes/tcltk/TclTk-file-open-save-dialogs/}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item multiple output filenames in R - Stack Overflow asked and edited by Gabelins on Feb 1 2013. See \url{https://stackoverflow.com/questions/14651594/multiple-output-filenames-in-r}.
   \item r - Regex return file name, remove path and file extension - Stack Overflow answered and edited by Ananda Mahto on Feb 25 20134. See \url{https://stackoverflow.com/questions/15073753/regex-return-file-name-remove-path-and-file-extension/15073919}.
}
}
\usage{
sat_enthalpy(
  file = tk_choose.files(default = "", caption = "Select file to open", multi = FALSE,
    filters = matrix(c("Comma-separated value file", ".csv", "MS Excel spreadsheet",
    ".xlsx", "MS Excel 97-2003 spreadsheet", ".xls"), 6, 2, byrow = TRUE)),
  sheet = 1,
  overwrite = TRUE,
  output = c("console", "csv", "xlsx")
)

sat_enthalpy2(
  file = NULL,
  sheet = 1,
  elevation = NULL,
  tbegin = NULL,
  tend = NULL,
  tincrement = NULL,
  overwrite = TRUE,
  output = c("console", "csv", "xlsx")
)
}
\arguments{
\item{file}{Input file (.xls, .xlsx, or .csv)}

\item{sheet}{Sheet number or sheet name for the input file (default is
sheet 1)}

\item{overwrite}{If \code{TRUE}, overwrite any existing spreadsheet.}

\item{output}{The output format of the resulting data.table
(console, .csv, or .xlsx)}

\item{elevation}{numeric vector that contains the location elevation in feet}

\item{tbegin}{numeric vector that contains the beginning temperature in
degrees F}

\item{tend}{numeric vector that contains the ending temperature in
degrees F}

\item{tincrement}{numeric vector that contains the temperature increment in
degrees F}
}
\value{
data.table with the output parameters displayed on the console or as
       a spreadsheet
}
\description{
sat_enthalpy and sat_enthalpy2 solve for the saturated enthalpy (H) given an
elevation in feet and a range of temperature values (degrees F).
}
\details{
The sat_enthalpy function provides a file dialog for the user to choose the
selected file.

The sat_enthalpy2 function either allows the user to provide the elevation
and temperature values without a file or allows the user to provide a file
without using a file dialog.



H is expressed as

	\deqn{H = \left(0.24 \times T\right) + \left[W \times \left(1061 + 0.444 \times T\right)\right]}

\describe{
\item{\emph{H}}{enthalpy (Btu/lb)}
\item{\emph{T}}{dry-bulb temperature (degrees F)}
\item{\emph{W}}{specific humidity (lbwater / lbdry air)}
}


where W or SH (Specific Humidity) is expressed as

	\deqn{W = \left(0.622 \times E\right)/\left(Mb - \left(0.378 \times E\right)\right)}

\describe{
\item{\emph{W}}{W or SH -- Specific Humidity (kg/kg)}
\item{\emph{E}}{Vapor pressure in saturated air at this temperature (millibars)}
\item{\emph{Mb}}{Pressure (millibars)}
}
}
\examples{
\dontrun{
library("ie2misc")
# Example to check the input file format

# Copy and paste the following code into the R console if you
# wish to see the input file format.
library("openxlsx")
openXL(system.file("extdata", "Saturated_Enthalpy_Example_Input.xlsx",
package = "ie2misc"))
  # opens the workbook using the default spreadsheet application



# Examples to show different use cases

sat_enthalpy(output = "csv")
# The sheet number is 1 (default) and the output is csv


sat_enthalpy2(system.file("extdata", "Saturated_Enthalpy_Example_Input.xlsx"
, package = "ie2misc"), output = "xlsx")
# The sheet number is 1 (default) and the output is xlsx


sat_enthalpy2(system.file("extdata", "Saturated_Enthalpy_Example_Input.csv",
package = "ie2misc"), output = "console")
# The sheet number is 1 (default) and the output is the console


sat_enthalpy2(elevation = 1200, tbegin = 32, tend = 180,
tincrement = 0.01, output = "csv")
# elevation = 1200 feet, tbegin = 32 degrees F, tend = 180 degrees F,
# tincrement = 0.01 degrees F
}


}
\references{
\enumerate{
   \item "Andrew Revering's List of Meteorological Formulas", \url{http://www.aprweather.com/pages/calc.htm}.
   \item Functional Testing and Design Guides, \emph{Functional Testing Guide: from the Fundamentals to the Field}, "Sidebar 3: How to Calculate Enthalpy", \url{https://web.archive.org/web/20150216015428/https://www.ftguide.org/ftg/IntegratedOperation/IOC-Sidebars-1-3/IOC-SB3-How-To-Calculate-Enthalpy.htm}. Retrieved thanks to the Internet Archive: Wayback Machine
}
}
\author{
Irucka Embry [R version], Timothy H. Diehl [Microsoft Excel(R) spreadsheet]
}
