% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat_vapor_pressure.R
\encoding{UTF-8}
\name{surf_tens_water}
\alias{surf_tens_water}
\title{Water Surface Tension for Liquid Water}
\usage{
surf_tens_water(T, units = c("SI", "Eng", "Absolute"))
}
\arguments{
\item{T}{numeric vector that contains the temperature (degrees Celsius,
degrees Fahrenheit, or Kelvin)}

\item{units}{character vector that contains the system of units (options are
\code{SI} for International System of Units, \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom), or \code{Absolute} for Absolute Units)}
}
\value{
the surface tension as a numeric vector. The units are not returned.
}
\description{
This function solves for the surface tension of water using only the
temperature of the water in either units of degrees Celsius, degrees
Fahrenheit, or Kelvin.
}
\details{
The simplified equation is expressed as

\deqn{\\sigma = \frac{1}{a + bT + cT^2 + dT^3}}

with

\deqn{a = 0.075652711}
\deqn{b = -0.00013936956}
\deqn{c = -3.0842103 * 10 ^ -7}
\deqn{d = 2.7588435 * 10 ^ -10}

\describe{
  \item{\emph{\\sigma}}{Water Surface Tension (N/m or lbf/ft)}
  \item{\emph{T}}{the water temperature, degrees Celsius}
}
}
\examples{
# Example (Compare to the tabulated values in the Reference paper)

install.load::load_package("iemisc", "data.table", "round")

T <- c(0, 0.01, 3.86, seq(5, 95, by = 5), 99.974, seq(100, 150, by = 5))

surface_tension <- data.table("Temperature (degrees C)" = T, "omega (N / m)"
= round_r3(surf_tens_water(T, units = "SI"), d = 5)); surface_tension





}
\references{
C. O. Popiel & J. Wojtkowiak (1998). "Simple Formulas for Thermophysical Properties of Liquid Water for Heat Transfer Calculations (from 0C to 150C)". \emph{Heat Transfer Engineering}, 19:3, 87-101, \url{https://www.tandfonline.com/doi/abs/10.1080/01457639808939929}.
}
\author{
Irucka Embry
}
