`pig` <-
function(q,mu=1.0,lambda=1.0,kernel="normal",parameter.nu=1.0,lower.tail=TRUE,log.p=FALSE){
mu2<-mu
lambda2<-lambda
nu2<-parameter.nu
n<-length(q)
vector.p<-seq(1,n)
if(kernel=="normal"){
dgign<-function(x,mu=mu2,lambda=lambda2){
cantidad<-sqrt(lambda/mu)*(sqrt(x/mu)-sqrt(mu/x))
jacobiano<-sqrt(lambda)/sqrt(x^3)
density<-dnorm(cantidad,0,1)*jacobiano
return(density)
}
for(i in 1:n){
valor<-q[i]
vector.p[i]<-0
if(valor!=0){
integral<-integrate(dgign,lower=0,upper=valor)
result<-integral$value
vector.p[i]<-result
}
}
fda<-vector.p
}
if(kernel=="t"){
dgigt<-function(x,mu=mu2,lambda=lambda2,nu=nu2){
cantidad<-sqrt(lambda/mu)*(sqrt(x/mu)-sqrt(mu/x))
jacobiano<-sqrt(lambda)/sqrt(x^3)
density<-dt(cantidad,nu)*jacobiano
return(density)
}
for(i in 1:n){
valor<-q[i]
vector.p[i]<-0
if(valor!=0){
integral<-integrate(dgigt,lower=0,upper=valor)
result<-integral$value
vector.p[i]<-result
}
}
fda<-vector.p
}
if(kernel=="logistic"){
dgiglog<-function(x,mu=mu2,lambda=lambda2){
cantidad<-sqrt(lambda/mu)*(sqrt(x/mu)-sqrt(mu/x))
jacobiano<-sqrt(lambda)/sqrt(x^3)
density<-dlogis(cantidad,0,1)*jacobiano
return(density)
}
for(i in 1:n){
valor<-q[i]
vector.p[i]<-0
if(valor!=0){
integral<-integrate(dgiglog,lower=0,upper=valor)
result<-integral$value
vector.p[i]<-result
}
}
fda<-vector.p
}
if(kernel=="Laplace"){
dgiglap<-function(x,mu=mu2,lambda=lambda2){
cantidad<-sqrt(lambda/mu)*(sqrt(x/mu)-sqrt(mu/x))
jacobiano<-sqrt(lambda)/sqrt(x^3)
density<-dLaplace(cantidad)*jacobiano
return(density)
}
for(i in 1:n){
valor<-q[i]
vector.p[i]<-0
if(valor!=0){
integral<-integrate(dgiglap,lower=0,upper=valor)
result<-integral$value
vector.p[i]<-result
}
}
fda<-vector.p
}
if(lower.tail==FALSE){fda<-(1-fda)}
if(log.p==TRUE){fda<-log(fda)}
return(fda)
}

