% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.r
\docType{class}
\name{sampler_net_attr_generator}
\alias{sampler_net_attr_generator}
\title{R6 Class for Single Component Sampler Settings}
\description{
The `sampler_net_attr` class is a simple R6 container used within the
`sampler_iglm` class. It holds the MCMC sampling parameters
for a single component of the `iglm` model, such as one attribute
(e.g., `x_attribute`) or a part of the network (e.g., `z_network` within
the overlap). It primarily stores the number of proposals and a random seed.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n_proposals}}{(`integer`) Read-only. The number of MCMC proposals per sampling step.}

\item{\code{seed}}{(`integer`) Read-only. The random seed used for this component's sampler.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-sampler_net_attr-new}{\code{sampler_net_attr_generator$new()}}
\item \href{#method-sampler_net_attr-print}{\code{sampler_net_attr_generator$print()}}
\item \href{#method-sampler_net_attr-gather}{\code{sampler_net_attr_generator$gather()}}
\item \href{#method-sampler_net_attr-set_n_proposals}{\code{sampler_net_attr_generator$set_n_proposals()}}
\item \href{#method-sampler_net_attr-set_seed}{\code{sampler_net_attr_generator$set_seed()}}
\item \href{#method-sampler_net_attr-save}{\code{sampler_net_attr_generator$save()}}
\item \href{#method-sampler_net_attr-clone}{\code{sampler_net_attr_generator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-new"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-new}{}}}
\subsection{Method \code{new()}}{
Create a new `sampler_net_attr` object. Validates inputs and sets
a random seed if none is provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$new(n_proposals = 10000, seed = NA, file = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_proposals}}{(integer) The number of MCMC proposals (iterations)
to perform for this specific component during each sampling step.
Default is 10000. Must be a non-negative integer.}

\item{\code{seed}}{(integer or `NA`) An integer seed for the random number
generator to ensure reproducibility for this component's sampling.
If `NA` (default), a random seed is generated automatically.}

\item{\code{file}}{(character or `NULL`) If provided, loads the sampler state from
the specified .rds file instead of initializing from parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `sampler_net_attr` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-print"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the sampler settings for this component.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$print(indent = "  ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indent}}{(character) A string used for indentation (e.g., spaces)
when printing, useful for nested structures. Default is "  ".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself, invisibly. Called for side effect.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-gather"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-gather}{}}}
\subsection{Method \code{gather()}}{
Gathers all data from private fields into a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$gather()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing all information of the sampler.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-set_n_proposals"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-set_n_proposals}{}}}
\subsection{Method \code{set_n_proposals()}}{
Sets the number of MCMC proposals for this component.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$set_n_proposals(n_proposals)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_proposals}}{(integer) The number of proposals to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-set_seed"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-set_seed}{}}}
\subsection{Method \code{set_seed()}}{
Sets the random seed for this component's sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$set_seed(seed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seed}}{(integer) The random seed to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-save"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-save}{}}}
\subsection{Method \code{save()}}{
Save the object's state to an .rds file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$save(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) The file file where the state will be saved.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_net_attr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_net_attr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_net_attr_generator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
