% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_measures.R
\name{cv_measures}
\alias{cv_measures}
\title{Calculate Coefficient of Variation subtypes}
\usage{
cv_measures(data, dt0 = NULL, inter_gap = 45, tz = "" )
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, a warning is produced and only 1st subject is used.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
When a data.frame object is passed, then a tibble object with
three columns: subject id and corresponding CV subtype values is returned.
}
\description{
The function cv_measures produces CV subtype values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for each cv subtype values is returned.

Missing values will be linearly interpolated when close enough to non-missing values.

\enumerate{
\item CVmean:

Calculated by first taking the coefficient of variation of each day's glucose measurements,
then taking the mean of all the coefficient of variation. That is, for x
days we compute cv_1 ... cv_x daily coefficient of variations and calculate
\eqn{1/x * \sum [(cv_i)]}

\item CVsd:

Calculated by first taking the coefficient of variation of each day's glucose measurements,
then taking the standard deviation of all the coefficient of variations. That is, for d
days we compute cv_1 ... cv_d daily coefficient of variations and calculate SD([cv_1, cv_2, ... cv_d])
}
}
\examples{

data(example_data_1_subject)
cv_measures(example_data_1_subject)

data(example_data_5_subject)
cv_measures(example_data_5_subject)

}
\references{
Umpierrez, et.al. (2018) Glycemic Variability: How to Measure and Its Clinical
Implication for Type 2 Diabetes
\emph{The American Journal of Medical Sciences} \strong{356} .518-527,
\doi{10.1016/j.amjms.2018.09.010}.
}
