% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igo_dyadic.R
\name{igo_dyadic}
\alias{igo_dyadic}
\title{Extract the Joint Membership of a pair of Countries across IGOs.}
\source{
\href{https://correlatesofwar.org/data-sets/IGOs/}{\strong{Codebook Version 3 IGO Data}} for full reference.
}
\usage{
igo_dyadic(country1, country2, year = 1816:2014, ioname = NULL)
}
\arguments{
\item{country1}{A single state, used as a base of comparison. It could be
any valid name or code of a state as specified on \link{states2016}.}

\item{country2}{A state of vector of states to be compared with
\code{country1}.}

\item{year}{Year to be assessed, an integer or an array of year.}

\item{ioname}{Optional. \code{ioname} or vector of \code{ioname}
corresponding to the IGOs to be assessed. If \code{NULL} (the default),
all IGOs would be extracted. See codes on \code{\link[=igo_search]{igo_search()}}.}
}
\value{
A coded data frame representing the years and country dyad (rows)
and the IGOs selected (columns). See Details
}
\description{
Dyadic version of the data. The unit of observation is a dyad
of countries. It provides a summary of the joint memberships of two IGOs
over time.
}
\details{
This function tries to replicate the information contained in the original
file distributed by The Correlates of War Project
(\code{dyadic_format3.dta}). That file is not included in this package due
to its size.

The result is a data frame containing the common years of the states
selected via \verb{country1, country2, year} by rows.

An additional column \code{dyadid}, computed as \code{(1000*ccode1)+ccode2}
is provided in order to identify relationships.

For each IGO selected via \code{ioname} (or all if the default
option has been used) a column (using lowercase \code{ioname} as
identifier) is provided with the following code system:
\tabular{cc}{
\strong{Category} \tab \strong{Numerical Value}\cr
No Joint Membership \tab 0 \cr
Joint Full Membership \tab 1 \cr
Missing data \tab -9 \cr
State Not System Member \tab -1 \cr
}
If one state in an IGO is a full member but the other is an associate
member or observer, that IGO is not coded as a joint membership.

\strong{Differences with the original dataset}

There are some differences on the results provided by this function and the
original dataset on some IGOs regarding the "Missing Data" (-9) and
"State Not System Member" (-1). However it is not clear how to fully
replicate those values.

See
\href{https://correlatesofwar.org/data-sets/IGOs/}{\strong{Codebook Version 3 IGO Data}}
}
\examples{
usa_esp <- igo_dyadic("USA", "Spain")
nrow(usa_esp)
ncol(usa_esp)

dplyr::tibble(usa_esp)

# Using custom parameters
custom <- igo_dyadic(
  country1 = "France",
  country2 =
    c("Sweden", "Austria"),
  year = 1992:1995,
  ioname = "EU"
)

dplyr::tibble(custom)

}
\references{
Pevehouse, Jon CW, Timothy Nordstrom, Roseanne W McManus, and Anne Spencer
Jamison. "Tracking Organizations in the World: The Correlates of War
IGO Version 3.0 Datasets." \emph{Journal of Peace Research} 57, no. 3
(May 2020): 492-503.
}
\seealso{
\link{state_year_format3},  \link{states2016},
\code{\link[=igo_search]{igo_search()}}.
}
