% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{incident}
\alias{incident}
\title{Incident edges of a vertex in a graph}
\usage{
incident(graph, v, mode = c("all", "out", "in", "total"))
}
\arguments{
\item{graph}{The input graph.}

\item{v}{The vertex of which the indicent edges are queried.}

\item{mode}{Whether to query outgoing (\sQuote{out}), incoming
(\sQuote{in}) edges, or both types (\sQuote{all}). This is
ignored for undirected graphs.}
}
\value{
An edge sequence containing the incident edges of
  the input vertex.
}
\description{
Incident edges of a vertex in a graph
}
\examples{
g <- make_graph("Zachary")
incident(g, 1)
incident(g, 34)
}
\seealso{
Other structural queries: \code{\link{[.igraph}},
  \code{\link{[[.igraph}}, \code{\link{adjacent_vertices}},
  \code{\link{are_adjacent}}, \code{\link{ends}},
  \code{\link{get.edge.ids}}, \code{\link{gorder}},
  \code{\link{gsize}}, \code{\link{head_of}},
  \code{\link{incident_edges}}, \code{\link{is_directed}},
  \code{\link{neighbors}}, \code{\link{tail_of}}
}
