% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_fast_greedy}
\alias{cluster_fast_greedy}
\alias{fastgreedy.community}
\title{Community structure via greedy optimization of modularity}
\usage{
cluster_fast_greedy(graph, merges = TRUE, modularity = TRUE,
  membership = TRUE, weights = E(graph)$weight)
}
\arguments{
\item{graph}{The input graph}

\item{merges}{Logical scalar, whether to return the merge matrix.}

\item{modularity}{Logical scalar, whether to return a vector containing the
modularity after each merge.}

\item{membership}{Logical scalar, whether to calculate the membership vector
corresponding to the maximum modularity score, considering all possible
community structures along the merges.}

\item{weights}{If not \code{NULL}, then a numeric vector of edge weights.
The length must match the number of edges in the graph.  By default the
\sQuote{\code{weight}} edge attribute is used as weights. If it is not
present, then all edges are considered to have the same weight.
Larger edge weights correspond to stronger connections.}
}
\value{
\code{cluster_fast_greedy} returns a \code{\link{communities}}
object, please see the \code{\link{communities}} manual page for details.
}
\description{
This function tries to find dense subgraph, also called communities in
graphs via directly optimizing a modularity score.
}
\details{
This function implements the fast greedy modularity optimization algorithm
for finding community structure, see A Clauset, MEJ Newman, C Moore: Finding
community structure in very large networks,
http://www.arxiv.org/abs/cond-mat/0408187 for the details.
}
\examples{

g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1,6, 1,11, 6, 11))
fc <- cluster_fast_greedy(g)
membership(fc)
sizes(fc)

}
\references{
A Clauset, MEJ Newman, C Moore: Finding community structure in
very large networks, http://www.arxiv.org/abs/cond-mat/0408187
}
\seealso{
\code{\link{communities}} for extracting the results.

See also \code{\link{cluster_walktrap}},
\code{\link{cluster_spinglass}},
\code{\link{cluster_leading_eigen}} and
\code{\link{cluster_edge_betweenness}} for other methods.
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com} for the R interface.
}
\keyword{graphs}
