% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_as_star}
\alias{layout_as_star}
\alias{layout.star}
\alias{as_star}
\title{Generate coordinates to place the vertices of a graph in a star-shape}
\usage{
layout_as_star(graph, center = V(graph)[1], order = NULL)

as_star(...)
}
\arguments{
\item{graph}{The graph to layout.}

\item{center}{The id of the vertex to put in the center. By default it is
the first vertex.}

\item{order}{Numeric vector, the order of the vertices along the perimeter.
The default ordering is given by the vertex ids.}

\item{...}{Arguments to pass to \code{layout_as_star}.}
}
\value{
A matrix with two columns and as many rows as the number of vertices
in the input graph.
}
\description{
A simple layout generator, that places one vertex in the center of a circle
and the rest of the vertices equidistantly on the perimeter.
}
\details{
It is possible to choose the vertex that will be in the center, and the
order of the vertices can be also given.
}
\examples{

g <- make_star(10)
layout_as_star(g)

## Alternative form
layout_(g, as_star())
}
\seealso{
\code{\link{layout}} and \code{\link{layout.drl}} for other layout
algorithms, \code{\link{plot.igraph}} and \code{\link{tkplot}} on how to
plot graphs and \code{\link{star}} on how to create ring graphs.

Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_tree}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_randomly}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_lgl}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{layout_}}, \code{\link{merge_coords}},
  \code{\link{norm_coords}}, \code{\link{normalize}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
