% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{is_dag}
\alias{is_dag}
\alias{is.dag}
\title{Directed acyclic graphs}
\usage{
is_dag(graph)
}
\arguments{
\item{graph}{The input graph. It may be undirected, in which case
\code{FALSE} is reported.}
}
\value{
A logical vector of length one.
}
\description{
This function tests whether the given graph is a DAG, a directed acyclic
graph.
}
\details{
\code{is_dag()} checks whether there is a directed cycle in the graph. If not,
the graph is a DAG.
}
\examples{

g <- make_tree(10)
is_dag(g)
g2 <- g + edge(5, 1)
is_dag(g2)
}
\seealso{
Other paths: 
\code{\link{all_simple_paths}()},
\code{\link{distance_table}()},
\code{\link{eccentricity}()},
\code{\link{radius}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} for the C code, Gabor Csardi
\email{csardi.gabor@gmail.com} for the R interface.
}
\concept{paths}
\keyword{graphs}
