% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{convex_hull}
\alias{convex_hull}
\alias{convex.hull}
\title{Convex hull of a set of vertices}
\usage{
convex_hull(data)
}
\arguments{
\item{data}{The data points, a numeric matrix with two columns.}
}
\value{
A named list with components: \item{resverts}{The indices of the
input vertices that constritute the convex hull.} \item{rescoords}{The
coordinates of the corners of the convex hull.}
}
\description{
Calculate the convex hull of a set of points, i.e. the covering polygon that
has the smallest area.
}
\examples{

M <- cbind(runif(100), runif(100))
convex_hull(M)
}
\references{
Thomas H. Cormen, Charles E. Leiserson, Ronald L. Rivest, and
Clifford Stein. Introduction to Algorithms, Second Edition. MIT Press and
McGraw-Hill, 2001. ISBN 0262032937. Pages 949-955 of section 33.3: Finding
the convex hull.
}
\seealso{
Other other: 
\code{\link{running_mean}()},
\code{\link{sample_seq}()},
\code{\link{srand}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com}
}
\concept{other}
\keyword{graphs}
