% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{erdos.renyi.game}
\alias{erdos.renyi.game}
\alias{random.graph.game}
\title{Generate random graphs according to the Erdős-Rényi model}
\usage{
erdos.renyi.game(
  n,
  p.or.m,
  type = c("gnp", "gnm"),
  directed = FALSE,
  loops = FALSE
)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p.or.m}{Either the probability for drawing an edge between two
arbitrary vertices (\eqn{G(n,p)} graph), or the number of edges in the graph (for
\eqn{G(n,m)} graphs).}

\item{type}{The type of the random graph to create, either \code{gnp()}
(\eqn{G(n,p)} graph) or \code{gnm()} (\eqn{G(n,m)} graph).}

\item{directed}{Logical, whether the graph will be directed, defaults to
FALSE.}

\item{loops}{Logical, whether to add loop edges, defaults to FALSE.}
}
\value{
A graph object.
}
\description{
This model is very simple, every possible edge is created with the same
constant probability.
}
\details{
In \eqn{G(n,p)} graphs, the graph has \sQuote{n} vertices and for each edge the
probability that it is present in the graph is \sQuote{p}.

In \eqn{G(n,m)} graphs, the graph has \sQuote{n} vertices and \sQuote{m} edges,
and the \sQuote{m} edges are chosen uniformly randomly from the set of all
possible edges. This set includes loop edges as well if the \code{loops}
parameter is TRUE.

\code{random.graph.game()} is an alias to this function.
}
\section{Deprecated}{


Since igraph version 0.8.0, both \code{erdos.renyi.game()} and
\code{random.graph.game()} are deprecated, and \code{\link[=sample_gnp]{sample_gnp()}} and
\code{\link[=sample_gnm]{sample_gnm()}} should be used instead.
}

\examples{

g <- erdos.renyi.game(1000, 1 / 1000)
degree_distribution(g)

}
\references{
Erdos, P. and Renyi, A., On random graphs, \emph{Publicationes
Mathematicae} 6, 290--297 (1959).
}
\seealso{
\code{\link[=sample_pa]{sample_pa()}}

Other games: 
\code{\link{connect}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
