% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{path}
\alias{path}
\title{Helper function to add or delete edges along a path}
\usage{
path(...)
}
\arguments{
\item{...}{See details below.}
}
\value{
A special object that can be used together with igraph
graphs and the plus and minus operators.
}
\description{
This function can be used to add or delete edges that form a path.
}
\details{
When adding edges via \code{+}, all unnamed arguments are
concatenated, and each element of a final vector is interpreted
as a vertex in the graph. For a vector of length \eqn{n+1}, \eqn{n}
edges are then added, from vertex 1 to vertex 2, from vertex 2 to vertex
3, etc. Named arguments will be used as edge attributes for the new
edges.

When deleting edges, all attributes are concatenated and then passed
to \code{\link[=delete_edges]{delete_edges()}}.
}
\examples{
# Create a (directed) wheel
g <- make_star(11, center = 1) + path(2:11, 2)
plot(g)

g <- make_empty_graph(directed = FALSE, n = 10) \%>\%
  set_vertex_attr("name", value = letters[1:10])

g2 <- g + path("a", "b", "c", "d")
plot(g2)

g3 <- g2 + path("e", "f", "g", weight = 1:2, color = "red")
E(g3)[[]]

g4 <- g3 + path(c("f", "c", "j", "d"), width = 1:3, color = "green")
E(g4)[[]]
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{vertex}()}
}
\concept{functions for manipulating graph structure}
