% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_heatmap.R
\docType{methods}
\name{main_heatmap}
\alias{main_heatmap}
\alias{main_heatmap,matrix-method}
\title{main_heatmap}
\usage{
\S4method{main_heatmap}{matrix}(data, name = "Signal",
  x = default_x(data), y = default_y(data),
  colors = pick_continuous_colors(zmid, zmin, zmax),
  colorbar_grid = setup_colorbar_grid(), colorbar_position = 1,
  zmid = 0, zmin = min(data, na.rm = TRUE), zmax = max(data, na.rm =
  TRUE), orientation = c("horizontal", "vertical"),
  x_categorical = NULL, y_categorical = NULL,
  row_order = seq_len(nrow(data)), col_order = seq_len(ncol(data)),
  text = signif(data, digits = 3), tooltip = setup_tooltip_options(),
  xname = "x", yname = "y", pname = name, source = "iheatmapr",
  layout = list())
}
\arguments{
\item{data}{matrix}

\item{name}{name of colorbar}

\item{x}{x axis labels (by default rownames of data)}

\item{y}{y axis labels (by default colnames of data)}

\item{colors}{color palette or vector of colors}

\item{colorbar_grid}{colorbar grid parameters, should be result from 
\code{\link{setup_colorbar_grid}}}

\item{colorbar_position}{colorbar placement, should be positive integer}

\item{zmid}{midpoint for colorscale}

\item{zmin}{minimum for colorscale}

\item{zmax}{maximum for colorscale}

\item{orientation}{should new main plots be added horizontally or vertically?}

\item{x_categorical}{is x categorical?  will guess if not provided}

\item{y_categorical}{is y categorical?  will guess if not provided}

\item{row_order}{row ordering for this heatmap-- will be used for all 
subsequent elements sharing y axis}

\item{col_order}{column ordering for this heatmap-- will be used for all 
subsequent elements sharing x axis}

\item{text}{text of value to display for data}

\item{tooltip}{tooltip options, see \code{\link{setup_tooltip_options}}}

\item{xname}{internal name for xaxis}

\item{yname}{internal name for yaxis}

\item{pname}{internal plot name}

\item{source}{source name for use with shiny}

\item{layout}{list of layout attributes to pass to plotly, 
eg. list(font = list(size = 15))}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Plots initial heatmap, creates Iheatmap object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- main_heatmap(mat) 

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_iheatmap}}, \code{\link{to_widget}},  
\code{\link{iheatmap}}, \code{\link{Iheatmap-class}}
}
\author{
Alicia Schep
}
