% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{iheid_palette}
\alias{iheid_palette}
\title{An IHEID palette generator}
\source{
Adapted from
\url{https://github.com/karthik/wesanderson/blob/master/R/colors.R}
}
\usage{
iheid_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. Current choices are:
\code{IHEID}, \code{Centres}, and \code{SDGs}.}

\item{n}{Number of colors desired. If omitted, uses all colours.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.}
}
\value{
A vector of colours.
}
\description{
These are a few color palettes useful for members of the  Geneva Graduate Institute.
This function calls one of three official palettes in
\code{\link{iheid_palette}}: for the Institute, for the Centres, and for the
SDGs.
}
\examples{
iheid_palette("IHEID")
iheid_palette("Centres")
iheid_palette("SDGs")

# If you need more colours than normally found in a palette, you
# can use a continuous palette to interpolate between existing
# colours
pal <- iheid_palette(21, name = "Centres", type = "continuous")
image(volcano, col = pal)
}
\keyword{colors}
