% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour_detector.R
\name{plot.cld}
\alias{plot.cld}
\title{Plot the detected contour lines from the image_contour_detector}
\usage{
\method{plot}{cld}(x, ...)
}
\arguments{
\item{x}{an object of class cld as returned by \code{\link{image_contour_detector}}}

\item{...}{further arguments passed on to plot}
}
\value{
invisibly a SpatialLines object with the contour lines
}
\description{
Plot the detected contour lines from the image_contour_detector
}
\examples{
library(pixmap)
imagelocation <- system.file("extdata", "image.pgm", package="image.ContourDetector")
image <- read.pnm(file = imagelocation, cellres = 1)
contourlines <- image_contour_detector(image@grey * 255)
plot(image)
plot(contourlines, add = TRUE, col = "red")
}
