% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textlinedetector.R
\name{image_textlines_astar}
\alias{image_textlines_astar}
\title{Text Line Segmentation based on the A* Path Planning Algorithm}
\usage{
image_textlines_astar(x, morph = FALSE, step = 2, mfactor = 5, trace = FALSE)
}
\arguments{
\item{x}{an object of class magick-image}

\item{morph}{logical indicating to apply a morphological 5x5 filter}

\item{step}{step size of A-star}

\item{mfactor}{multiplication factor in the cost heuristic of the A-star algorithm}

\item{trace}{logical indicating to show the evolution of the line detection}
}
\value{
a list with elements
\itemize{
\item{n: the number of lines found}
\item{overview: an opencv-image of the detected areas}
\item{paths: a list of data.frame's with the x/y location of the baseline paths}
\item{textlines: a list of opencv-image's, one for each rectangular text line area}
\item{lines: a data.frame with the x/y positions of the detected lines}
}
}
\description{
Text Line Segmentation based on the A* Path Planning Algorithm
}
\examples{
library(opencv)
library(magick)
library(image.textlinedetector)
path   <- system.file(package = "image.textlinedetector", "extdata", "example.png")
img    <- image_read(path)
img    <- image_resize(img, "x1000")
areas  <- image_textlines_astar(img, morph = TRUE, step = 2, mfactor = 5, trace = TRUE)
areas  <- lines(areas, img)
areas$n
areas$overview
areas$lines
areas$textlines[[2]]
areas$textlines[[4]]
combined <- lapply(areas$textlines, FUN=function(x) image_read(ocv_bitmap(x)))
combined <- do.call(c, combined)
combined
image_append(combined, stack = TRUE)

plt <- image_draw(img)
lapply(areas$paths, FUN=function(line){
  lines(x = line$x, y = line$y, col = "red")  
})
dev.off()
plt
}
