% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{as.cimg.function}
\alias{as.cimg.function}
\title{Create an image by sampling a function}
\usage{
\method{as.cimg}{function}(obj, width, height, depth = 1,
  normalise.coord = FALSE, ...)
}
\arguments{
\item{obj}{a function with arguments (x,y) or (x,y,z). Must be vectorised.}

\item{width}{width of the image (in pixels)}

\item{height}{height of the image (in pixels)}

\item{depth}{depth of the image (in pixels)}

\item{normalise.coord}{coordinates are normalised so that x,y,z are in (0,1) (default FALSE)}

\item{...}{ignored}
}
\value{
an object of class cimg
}
\description{
Similar to as.im.function from the spatstat package, but simpler. Creates a grid of pixel coordinates x=1:width,y=1:height and (optional) z=1:depth, and evaluates the input function at these values.
}
\examples{
im = as.cimg(function(x,y) cos(sin(x*y/100)),100,100)
plot(im)
im = as.cimg(function(x,y) cos(sin(x*y/100)),100,100,normalise.coord=TRUE)
plot(im)
}
\author{
Simon Barthelme
}

