% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{get.stencil}
\alias{get.stencil}
\title{Return pixel values in a neighbourhood defined by a stencil}
\usage{
get.stencil(im, stencil, ...)
}
\arguments{
\item{im}{an image}

\item{stencil}{a data.frame with values dx,dy,[dz],[dcc] defining the neighbourhood}

\item{...}{where to center, e.g. x = 100,y = 10,z=3,cc=1}
}
\value{
pixel values in neighbourhood
}
\description{
A stencil defines a neighbourhood in an image (for example, the four nearest neighbours in a 2d image). This function centers the stencil at a certain pixel and returns the values of the neighbourhing pixels.
}
\examples{
#The following stencil defines a neighbourhood that
#includes the next pixel to the left (delta_x = -1) and the next pixel to the right (delta_x = 1)
stencil <- data.frame(dx=c(-1,1),dy=c(0,0))
im <- as.cimg(function(x,y) x+y,w=100,h=100)
get.stencil(im,stencil,x=50,y=50)

#A larger neighbourhood that includes pixels upwards and
#downwards of center (delta_y = -1 and +1)
stencil <- stencil.cross()
im <- as.cimg(function(x,y) x,w=100,h=100)
get.stencil(im,stencil,x=5,y=50)
}
\author{
Simon Barthelme
}

