% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{label}
\alias{label}
\title{Label connected components.}
\usage{
label(im, high_connectivity = FALSE, tolerance = 0)
}
\arguments{
\item{im}{an image}

\item{high_connectivity}{4(false)- or 8(true)-connectivity
in 2d case, and between 6(false)- or 26(true)-connectivity in 3d case. Default FALSE}

\item{tolerance}{Tolerance used to determine if two neighboring pixels belong to the same region.}
}
\description{
The algorithm of connected components computation has been primarily done
by A. Meijster, according to the publication:
'W.H. Hesselink, A. Meijster, C. Bron, "Concurrent Determination of Connected Components.",
      In: Science of Computer Programming 41 (2001), pp. 173--194'.
}
\examples{
imname <- system.file('extdata/parrots.png',package='imager')
im <- load.image(imname) \%>\% grayscale
#Thresholding yields different discrete regions of high intensity
regions <- isoblur(im,10) \%>\% threshold("97\%") 
labels <- label(regions)
layout(t(1:2))
plot(regions,"Regions")
plot(labels,"Labels")

}

