% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{pixel.grid}
\alias{pixel.grid}
\title{Return the pixel grid for an image}
\usage{
pixel.grid(im, standardise = FALSE, drop.unused = TRUE, dim = NULL)
}
\arguments{
\item{im}{an image}

\item{standardise}{If TRUE use a centered, scaled coordinate system. If FALSE use standard image coordinates (default FALSE)}

\item{drop.unused}{if TRUE ignore empty dimensions, if FALSE include them anyway (default TRUE)}

\item{dim}{a vector of image dimensions (optional, may be used instead of "im")}
}
\value{
a data.frame
}
\description{
The pixel grid for image im gives the (x,y,z,c) coordinates of each successive pixel as a data.frame. The c coordinate has been renamed 'cc' to avoid conflicts with R's c function.
NB: coordinates start at (x=1,y=1), corresponding to the top left corner of the image, unless standardise == TRUE, in which case we use the usual Cartesian coordinates with origin at the center of the image and scaled such that x varies between -.5 and .5, and a y arrow pointing up
}
\examples{
im <- as.cimg(array(0,c(10,10))) #A 10x10 image
pixel.grid(im) \%>\% head
pixel.grid(dim=dim(im)) \%>\% head #Same as above
pixel.grid(dim=c(10,10,3,2)) \%>\% head 
pixel.grid(im,standardise=TRUE) \%>\% head
pixel.grid(im,drop.unused=FALSE) \%>\% head
}
