% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{haar}
\alias{haar}
\title{Compute Haar multiscale wavelet transform.}
\usage{
haar(im, inverse = FALSE, nb_scales = 1L)
}
\arguments{
\item{im}{an image}

\item{inverse}{Compute inverse transform (default FALSE)}

\item{nb_scales}{Number of scales used for the transform.}
}
\description{
Compute Haar multiscale wavelet transform.
}
\examples{
\dontshow{cimg.limit.openmp()}
#Image compression: set small Haar coefficients to 0
hr <- haar(boats,nb=3) 
mask.low <- threshold(abs(hr),"75\%")
mask.high <- threshold(abs(hr),"95\%")
haar(hr*mask.low,inverse=TRUE,nb=3) \%>\% plot(main="75\% compression")
haar(hr*mask.high,inverse=TRUE,nb=3) \%>\% plot(main="95\% compression")
}
