% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neater.R
\name{neater}
\alias{neater}
\title{Fitering of oversampled data based on non-cooperative game theory}
\usage{
neater(
  dataset,
  newSamples,
  k = 3,
  iterations = 100,
  smoothFactor = 1,
  classAttr = "Class"
)
}
\arguments{
\item{dataset}{The original \code{data.frame}. All columns, except
\code{classAttr} one, have to be numeric or coercible to numeric.}

\item{newSamples}{A \code{data.frame} containing the samples to be filtered.
Must have the same structure as \code{dataset}.}

\item{k}{Integer. Number of nearest neighbours to use in KNN algorithm to
rule out samples. By default, 3.}

\item{iterations}{Integer. Number of iterations for the algorithm. By
default, 100.}

\item{smoothFactor}{A positive \code{numeric}. By default, 1.}

\item{classAttr}{\code{character}. Indicates the class attribute from
\code{dataset} and \code{newSamples}. Must exist in them.}
}
\value{
Filtered samples as a \code{data.frame} with same structure as
  \code{newSamples}.
}
\description{
Filters oversampled examples from a binary class \code{dataset} using game
theory to find out if keeping an example is worthy enough.
}
\details{
Uses game theory and Nash equilibriums to calculate the minority examples
probability of trully belonging to the minority class. It discards examples
which at the final stage of the algorithm have more probability of being a
majority example than a minority one.
}
\examples{
data(iris0)

newSamples <- smotefamily::SMOTE(iris0[,-5], iris0[,5])$syn_data
# SMOTE overrides Class attr turning it into class
# and dataset must have same class attribute as newSamples
names(newSamples) <- c(names(newSamples)[-5], "Class")

neater(iris0, newSamples, k = 5, iterations = 100,
       smoothFactor = 1, classAttr = "Class")
}
\references{
Almogahed, B.A.; Kakadiaris, I.A. Neater: Filtering of Over-Sampled Data
Using Non-Cooperative Game Theory. Soft Computing 19 (2014), Nr. 11, p.
3301–3322.
}
